import { HttpStatus, INestApplication } from '@nestjs/common';
import request from 'supertest';
import { getPrivateApp, getSigners } from '../utils/setup';

let app: INestApplication;
let signerWithAddress;

describe('Test Private Payment Tokens endpoints (e2e)', function () {
  beforeAll(async () => {
    app = await getPrivateApp();
    signerWithAddress = await getSigners();

    await app.init();
  });

  it(`/POST /tm/v1.0/paymant-tokens/mint - Mint payment token works`, async () => {
    const response = await request(app.getHttpServer())
      .post('/tm/v1.0/payment-tokens/mint')
      .send({
        amount: '1000',
        tradingAccount: signerWithAddress[1].address,
      });

    expect(response).toBeTruthy();
    expect(response.statusCode).toBe(HttpStatus.CREATED);
  });

  it.skip(`/GET /tm/v1.0/contract-info/payment-balances/accounts/{tid} - Get trading account payment token balance works`, async () => {
    const tid = signerWithAddress[1].address;
    const response = await request(app.getHttpServer())
      .get(`/tm/v1.0/contract-info/payment-balances/accounts/${tid}`)
      .query({ token: 'FDE' });

    expect(response).toBeTruthy();
    expect(parseInt(response.body.balance)).toBeGreaterThanOrEqual(0);
    expect(response.statusCode).toBe(HttpStatus.OK);
  });

  it(`/DELETE /tm/v1.0/payment-tokens/burn - Burn payment token works`, async () => {
    const response = await request(app.getHttpServer())
      .delete('/tm/v1.0/payment-tokens/burn')
      .send({
        tradingAccount: signerWithAddress[1].address,
        amount: '0',
      });

    expect(response).toBeTruthy();
    expect(typeof response.text).toBe('string');
    expect(response.text).toContain('Amount');
    expect(response.statusCode).toBe(HttpStatus.OK);
  });
});
